#All variables can be found in the excel Figure 16 Data.xlsx. Stata sometimes produces odd results for non-linear regressions. Therefore, I used R to conduct regressions. 
#The data used in regressions for each sample are in the following sheets:
#Sample (a), 1985Q1 to 1998Q1 is in the sheet ‘R data (a)’
#Sample (b), 1998Q2 to 2008Q2 is in the sheet ‘R data (b)’
#Sample (c), 2008Q3 to 2019Q4 is in the sheet ‘R data (c)’
#Sample (d), 2020Q1 to 2022Q3 is in the sheet ‘R data (d)’

#To obtain gamma estimation for each period, we shall export the data in the sheet corresponding to that period (specified above) to a csv file and import it to RStudio. Suppose the data set is named ‘data1’ in R. The code that conducts the regression is: 
#Sample (a):
model <- nls(pe ~ ((gamma)^ttau) * 4.35 + (1-(gamma))*cpi2_median + (1-(gamma)) * ((gamma)*lag1CPI + ((gamma)^2)*lag2CPI + ((gamma)^3)*lag3CPI + ((gamma)^4)*lag4CPI  + ((gamma)^5)*lag5CPI + ((gamma)^6)*lag6CPI + ((gamma)^7)*lag7CPI + ((gamma)^8)*lag8CPI + ((gamma)^9)*lag9CPI + ((gamma)^10)*lag10CPI + ((gamma)^11)*lag11CPI + ((gamma)^12)*lag12CPI + ((gamma)^13)*lag13CPI + ((gamma)^14)*lag14CPI + ((gamma)^15)*lag15CPI + ((gamma)^16)*lag16CPI + ((gamma)^17)*lag17CPI + ((gamma)^18)*lag18CPI + ((gamma)^19)*lag19CPI + ((gamma)^20)*lag20CPI + ((gamma)^21)*lag21CPI + ((gamma)^22)*lag22CPI + ((gamma)^23)*lag23CPI + ((gamma)^24)*lag24CPI + ((gamma)^25)*lag25CPI + ((gamma)^26)*lag26CPI + ((gamma)^27)*lag27CPI + ((gamma)^28)*lag28CPI + ((gamma)^29)*lag29CPI + ((gamma)^30)*lag30CPI + ((gamma)^31)*lag31CPI + ((gamma)^32)*lag32CPI + ((gamma)^33)*lag33CPI + ((gamma)^34)*lag34CPI + ((gamma)^35)*lag35CPI + ((gamma)^36)*lag36CPI + ((gamma)^37)*lag37CPI + ((gamma)^38)*lag38CPI + ((gamma)^39)*lag39CPI + ((gamma)^40)*lag40CPI + ((gamma)^41)*lag41CPI + ((gamma)^42)*lag42CPI + ((gamma)^43)*lag43CPI + ((gamma)^44)*lag44CPI + ((gamma)^45)*lag45CPI + ((gamma)^46)*lag46CPI + ((gamma)^47)*lag47CPI + ((gamma)^48)*lag48CPI + ((gamma)^49)*lag49CPI + ((gamma)^50)*lag50CPI +((gamma)^51)*lag51CPI), start = list(gamma = 0.9), data = data1)
#Sample (b):
model <- nls(pe ~ ((gamma)^ttau) * 2.5 + (1-(gamma))*cpi2_median + (1-(gamma)) * ((gamma)*lag1CPI + ((gamma)^2)*lag2CPI + ((gamma)^3)*lag3CPI + ((gamma)^4)*lag4CPI  + ((gamma)^5)*lag5CPI + ((gamma)^6)*lag6CPI + ((gamma)^7)*lag7CPI + ((gamma)^8)*lag8CPI + ((gamma)^9)*lag9CPI + ((gamma)^10)*lag10CPI + ((gamma)^11)*lag11CPI + ((gamma)^12)*lag12CPI + ((gamma)^13)*lag13CPI + ((gamma)^14)*lag14CPI + ((gamma)^15)*lag15CPI + ((gamma)^16)*lag16CPI + ((gamma)^17)*lag17CPI + ((gamma)^18)*lag18CPI + ((gamma)^19)*lag19CPI + ((gamma)^20)*lag20CPI + ((gamma)^21)*lag21CPI + ((gamma)^22)*lag22CPI + ((gamma)^23)*lag23CPI + ((gamma)^24)*lag24CPI + ((gamma)^25)*lag25CPI + ((gamma)^26)*lag26CPI + ((gamma)^27)*lag27CPI + ((gamma)^28)*lag28CPI + ((gamma)^29)*lag29CPI + ((gamma)^30)*lag30CPI + ((gamma)^31)*lag31CPI + ((gamma)^32)*lag32CPI + ((gamma)^33)*lag33CPI + ((gamma)^34)*lag34CPI + ((gamma)^35)*lag35CPI + ((gamma)^36)*lag36CPI + ((gamma)^37)*lag37CPI + ((gamma)^38)*lag38CPI + ((gamma)^39)*lag39CPI), start = list(gamma = 0.9), data = data1)
#Sample (c)
model <- nls(pe ~ (gamma^(ttau)) * 2.5 + (1-gamma)*cpi2_median + (1-gamma) * (gamma*lag1CPI + (gamma^2)*lag2CPI + (gamma^3)*lag3CPI + (gamma^4)*lag4CPI  + (gamma^5)*lag5CPI + (gamma^6)*lag6CPI + (gamma^7)*lag7CPI + (gamma^8)*lag8CPI + (gamma^9)*lag9CPI + (gamma^10)*lag10CPI + (gamma^11)*lag11CPI + (gamma^12)*lag12CPI + (gamma^13)*lag13CPI + (gamma^14)*lag14CPI + (gamma^15)*lag15CPI + (gamma^16)*lag16CPI + (gamma^17)*lag17CPI + (gamma^18)*lag18CPI + (gamma^19)*lag19CPI + (gamma^20)*lag20CPI + (gamma^21)*lag21CPI + (gamma^22)*lag22CPI + (gamma^23)*lag23CPI + (gamma^24)*lag24CPI + (gamma^25)*lag25CPI + (gamma^26)*lag26CPI + (gamma^27)*lag27CPI + (gamma^28)*lag28CPI + (gamma^29)*lag29CPI + (gamma^30)*lag30CPI + (gamma^31)*lag31CPI + (gamma^32)*lag32CPI + (gamma^33)*lag33CPI + (gamma^34)*lag34CPI + (gamma^35)*lag35CPI + (gamma^36)*lag36CPI + (gamma^37)*lag37CPI + (gamma^38)*lag38CPI + (gamma^39)*lag39CPI + (gamma^40)*lag40CPI + (gamma^41)*lag41CPI + (gamma^42)*lag42CPI + (gamma^43)*lag43CPI + (gamma^44)*lag44CPI), start = list(gamma = 0.9), data = data1)
#Sample (d)
model <- nls(pe ~ ((gamma)^(ttau)) * 2.2 + (1-(gamma))*cpi2_median + (1-(gamma)) * ((gamma)*lag1CPI + ((gamma)^2)*lag2CPI + ((gamma)^3)*lag3CPI + ((gamma)^4)*lag4CPI  + ((gamma)^5)*lag5CPI + ((gamma)^6)*lag6CPI + ((gamma)^7)*lag7CPI + ((gamma)^8)*lag8CPI + ((gamma)^9)*lag9CPI), start = list(gamma = 0.9), data = data1)
#To view the result, we can use the code:
summary(model)
#The RSS is reported by the code: 
deviance(model)
#The fitted values for a given period can be computed by the code:
predict(model)
#The graph can be reproduced by plotting the predicted values against the SPF long run actual (pe in dataset).

